import QtQuick 2.0
import QtQuick.Controls 2.2

Rectangle{
   id: _aClock
   width:   200
   height:  200
   color:   "transparent"

//    border.color: "red" ;     border.width: 1
   Timer {
      interval: 100
      repeat: true
      running: true
      onTriggered: timeChanged()
    }
// MessageFrame{
// //   iRadius: 20
//    anchors.centerIn: _aClock
// //   color: "#33E5D0"
// //color: "#505078"
// //color: "#4f7850"
// color: "#ac5eba"
// borderWidth: 10
// }
   property int datePosX: 40
   property int dateYoffset: -80
   property int hours
   property int minutes
   property int seconds


    function timeChanged() {
        var date = new Date();
// Test        hours = date.getUTCHours();
        hours = date.getHours();
        minutes = date.getMinutes();
        seconds = date.getSeconds();
    }

   Rectangle
   {  id: _dateRec
      anchors.top: _aClock.top
      anchors.topMargin: _aClock.dateYoffset
      x: _aClock.datePosX
      DateSmall{
             _DateFormat: String("dd.MM.yyyy");

         currentPixelSize:    mainLayout.fontPixelSizeDefault
      }
   }

Item {
    id: clock
      anchors.fill: parent

    Image {
         id: clockFace
//         source: "assets/clock-face_.png"
         source:  mainLayout.clockImageFace_source
         anchors.fill: clock
         sourceSize.width:           clock.width
         sourceSize.height:          clock.height
//         visible: false
    }
   Rectangle
   {  id: hourHand
      x: _aClock.width/2 -hourHand.width/2
      width: _aClock.width/40
      height: _aClock.height
      color: "transparent" ;      // Debug border.width: 1;     border.color: "green";
    Image {
         id: hourHandImage
//         source: "assets/hour_.png"
         source:  mainLayout.clockImageHour_source
         width: hourHand.width
         height:  minuteHand.height*0.31 ///100*30
         anchors.bottom: hourHand.verticalCenter
      }
        transform: Rotation {
            id: hourRotation
            angle: (_aClock.hours * 30)+_aClock.minutes*0.5
            origin.x: hourHand.width/2
            origin.y: hourHand.height/2
            Behavior on angle {
                SpringAnimation {
                    spring: 2
                    damping: 0.2
                    modulus: 360
                }
            }
        }

   }
   Rectangle
   {  id: minuteHand
      x: _aClock.width/2 -hourHand.width/2
      width: _aClock.width/40
      height: _aClock.height
      color: "transparent" ;   // Debug  border.width: 1;     border.color: "green";

    Image {
         id: minuteHandImage
//         source:   "assets/minute_.png"
         source:  mainLayout.clockImageMinute_source
         width:   minuteHand.width
         height:  minuteHand.height*0.37
         anchors.bottom: minuteHand.verticalCenter

      }
        transform: Rotation {
            id: minuteRotation
            angle: _aClock.minutes * 6
            origin.x: minuteHand.width/2
            origin.y: minuteHand.height/2

            Behavior on angle {
                SpringAnimation {
                    spring: 2
                    damping: 0.2
                    modulus: 360
                }
            }
        }
    }
   Rectangle
   {  id: secondHand
      x: _aClock.width/2 -hourHand.width/2
      width: _aClock.width/60
      height: _aClock.height
      color: "transparent" ;   //   border.width: 1;     border.color: "green";

    Image {
        id: secondHandImage
//        source: "assets/second.png"
        source:   mainLayout.clockImageSecond_source
         width:   secondHand.width
         anchors.bottom: secondHand.verticalCenter
         height:  secondHand.height/2 -10
      }
      transform: Rotation {
            id: secondRotation
            angle:  _aClock.seconds * 6
            origin.x: minuteHand.width/2
            origin.y: minuteHand.height/2

            Behavior on angle {
                SpringAnimation {
                    spring: 2
                    damping: 0.2
                    modulus: 360
                }
            }
        }
    }

   Image {
      id: pointImage
//        source: "assets/second.png"
        source:   mainLayout.clockImagePoint_source
        anchors.centerIn: clock
        // x:  _aClock.width/2 - width/2
        // y: _aClock.height/2 - height/2//50 //292
        width:    _aClock.width/15 // 30
        height:   _aClock.width/15  //30
      }
// ersetzt mit pointImage
//     Rectangle {
// // 'abdeck' Punkt in der Mitte
//         x:  _aClock.width/2 - width/2
//         y: _aClock.height/2 - height/2//50 //292
// color: "#BABDBD"
// //       anchors.centerIn: _aClock
// //        color: "transparent"
// // border.color: "yellow"    border.width: 1
//         width:    _aClock.width/15 // 30
//         height:   _aClock.width/15  //30
//         radius:   _aClock.width/15  //30
//     }
 }
}
