import QtQuick 2.12

MouseArea {

   property int mKey: 1084
   property bool bAnimation: false
   property bool bIgnoreAction: false
   property bool mCtrlKey: false
   property bool blockRepeat:    false
   property bool bLongPressOnly: false
   property bool iInvertSendValue:  false;

   anchors.fill: parent
//   pressAndHoldInterval: 4000

   function handleKeyAction(value)
   {
         if(mCtrlKey)
            receiveButtonfromlib(mKey, value )
         else
         {  qmlkeypressSignaltolib(parent.myButtonId , mKey, value)
            console.log("TapHandler: -- send key: ", parent.myButtonId , mKey, value, "repeatTime:", pressAndHoldInterval)
         }
   }

   onPressAndHold:
   {
      if(!blockRepeat)
      {
         if(bAnimation)
            parent.state = "SELECTED"
         if(!bIgnoreAction)
             handleKeyAction(1)
      }
   }

   onReleased:
   {
      if(bAnimation)
         parent.state = "RELEASED"
      if(!bIgnoreAction)
      {  if(!bLongPressOnly)
            if(!iInvertSendValue)
               handleKeyAction(0)
      }
   }

   onPressed:
   {
      if(bAnimation)
         parent.state = "PRESSED"
      bIgnoreAction=false
      if(iInvertSendValue)
         handleKeyAction(0)

   }

   onCanceled:
   {
         bIgnoreAction = true;
         parent.state = "RELEASED"

   }
   onPositionChanged:
   {
//NOTE: pruefen ob Bewegung den Touchbereich verlassen hat, falls ja ist status gedrueckt ungueltig
      if( ( (mouseX>parent.width) || (mouseX<0) || (mouseY>parent.height) || (mouseY<0)  ) && !bIgnoreAction)
      {
         onCanceled()
      }
   }

}
